#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//nSpiral Circle Test 0_0_1Mod01.fsh   by  Chris_M_Thomasson
//https://www.shadertoy.com/view/MsKyR3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Fractal Spin by Chris M. Thomasson



// Viewport Axes
struct ct_axes
{
    float xmin;
    float xmax;
    float ymin;
    float ymax;
};
    
    
ct_axes ct_axes_from_radius(
    in vec3 vpcircle
){
    return ct_axes(
        vpcircle.x - vpcircle.z,
        vpcircle.x + vpcircle.z,
        vpcircle.y - vpcircle.z,
        vpcircle.y + vpcircle.z
    );
}


// Simple 2d Plane
struct ct_plane2d
{
    ct_axes axes;
    float xstep;
    float ystep;
};
    
    
ct_plane2d ct_plane2d_create(
    in ct_axes axes
){
    float awidth = axes.xmax - axes.xmin;
    float aheight = axes.ymax - axes.ymin;
    
    float daspect = abs(iResolution.y / iResolution.x);
    float waspect = abs(aheight / awidth);
    
    if (daspect > waspect)
    {
        float excess = aheight * (daspect / waspect - 1.0);
        axes.ymax += excess / 2.0;
        axes.ymin -= excess / 2.0;
    }
    
    else if (daspect < waspect)
    {
        float excess = awidth * (waspect / daspect - 1.0);
        axes.xmax += excess / 2.0;
        axes.xmin -= excess / 2.0;
    }
    
    return ct_plane2d(
        axes,
        (axes.xmax - axes.xmin) / iResolution.x,
        (axes.ymax - axes.ymin) / iResolution.y
    );
}


vec2 ct_plane2d_project(
	in ct_plane2d self,
    in vec2 z
){
	return vec2(
        self.axes.xmin + z.x * self.xstep,
        self.axes.ymin + z.y * self.ystep
    );
}


vec4 ct_circle(
    in vec2 c,
    in vec2 z,
    in float radius
){
    float d = length(c - z);
    
    if (d < radius) 
    {
        d = d / radius;
        float b = -(.25 + abs(sin(iTime)));
        return exp(b*dot(d,d) ) * vec4(1,.7,.4,0)*2.;
    }
    
    return vec4(0.0, 0.0, 0.0, 0.0);
}

vec2 ct_cmul(in vec2 p0, in vec2 p1)
{
    return vec2(p0.x * p1.x - p0.y * p1.y, p0.x * p1.y + p0.y * p1.x);
}


vec4 ct_spiral_arm(
    in vec2 c,
    in float astart,
    in int n
){
	vec4 color = vec4(0.0, 0.0, 0.0, 0.0);
    
    float rbase = 1.0 / float(n);
    float abase = 6.28 / float(n);
    
    vec2 prev = vec2(0.0, 0.0);
    
    c = ct_cmul(c, c) + cos(iTime * .5) * .35;
    c = ct_cmul(c, c) + sin(iTime * .25) * .45;
    c = ct_cmul(c, c) + sin(iTime * .25) * .25;
    
    for (int i = 1; i < n + 1; ++i)
    {
        float angle = abase * float(i) + astart;
        float radius = rbase * float(i);
        
        vec2 cur = vec2(cos(angle) * radius, sin(angle) * radius);
        
        vec2 dif = cur - prev;
        
        float br = length(dif) / 2.0;
        
        vec2 mid = vec2(prev.x + dif.x * .5, prev.y + dif.y * .5);
        
        color += ct_circle(c, mid, br * (.2 + abs(sin(iTime * 1.5)) * .8));
        
        prev = cur;
    }
    
    
    return color;
}


// High-Level Entry
vec4 ct_main(
    in ct_plane2d plane,
    in vec2 c
){
    vec4 color = vec4(0.0, 0.0, 0.0, 0.0);
    
    vec2 center = vec2(0.0, 0.0);
    float radius = 1.8;
    //int n = 6;//2 + (int(floor(iTime * 3.)) % 16);
    
    int sn = 23;
    float aspin = -iTime * 1.0;
    
    int n = 6;
    float abase = 6.28 / float(n);
    
    for (int i = 0; i < n; ++i)
    {
     	float angle = abase * float(i) + aspin;
        
        color += ct_spiral_arm(c, angle, sn);
    }
    
    return color;
}



// Raw Entry.
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 vpcircle = vec3(
        0., 
        0., 
        abs(cos(iTime * .25)) + .5
    );
    
    ct_plane2d plane = ct_plane2d_create(
        ct_axes_from_radius(vpcircle)
    );
    
    vec2 c = ct_plane2d_project(plane, fragCoord);
    
    // Exec...
    vec4 color = ct_main(plane, c);
    
    fragColor = color;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

